<?php

namespace App\Helpers\Payment;

class PayTechService
{
    private $apiKey;
    private $apiSecret;
    private $baseUrl;

    public function __construct()
    {
        $this->apiKey = '7ede0ec9ea88fc6dec964a7a92d09a58be887707252155458c786320df531b7c';

        $this->apiSecret = '35067ab7e0772e5aec6e26b1e24c4ba19c1989c7ed210530092a99222e0e72f7';

        $this->baseUrl = 'https://paytech.sn/api/payment';
    }

    /**
     * Make a POST request using cURL
     *
     * @param string $url
     * @param array $data
     * @param array $headers
     * @return string
     */
    private function postRequest(string $url, array $data, array $headers = []): string
    {
        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array_merge([
            'Content-Type: application/x-www-form-urlencoded;charset=utf-8',
            'Content-Length: ' . strlen(http_build_query($data))
        ], $headers));

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new \Exception('cURL error: ' . curl_error($ch));
        }

        curl_close($ch);

        return $response;
    }

    /**
     * Request a payment from PayTech
     *
     * @param array $paymentData
     * @return array
     */
    public function requestPayment(array $paymentData): array
    {
        $url = $this->baseUrl . '/request-payment';



        $postData = [
            "item_name" => $paymentData['item_name'],
            "item_price" => $paymentData['item_price'],
            "command_name" => $paymentData['command_name'],
            "env" => $paymentData['env'] ?? 'test',
            "ref_command" => $paymentData['ref_command'],
            "currency" => $paymentData['currency'] ?? 'XOF',
            "success_url" => env('APP_URL') . '/paytech-success?user_id=' . $paymentData['user_id'] . '&amount=' . $paymentData['item_price'] . '&order_id=' . $paymentData['order_id'] . '&payment_for=' . $paymentData['payment_for'] . '&request_id=' . $paymentData['request_id'],
            "cancel_url" => env('APP_URL') . '/paytech-cancel',
            "custom-field" => $paymentData['custom_field'] ?? []
        ];


        // dd($url,$postData);


        $headers = [
            "API-KEY: {$this->apiKey}",
            "API-SECRET: {$this->apiSecret}"
        ];


        $response = $this->postRequest($url, $postData, $headers);

        return json_decode($response, true);
    }
}
