<?php

namespace App\Http\Controllers;
use Inertia\Inertia;
use App\Models\Request\Request as RequestModel;
use App\Base\Filters\Admin\RequestFilter;
use App\Base\Libraries\QueryFilter\QueryFilterContract;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Admin\Zone;
use App\Models\Admin\VehicleType;
use App\Models\Admin\Driver;
use App\Models\ThirdPartySetting;
use Kreait\Firebase\Contract\Database;
use App\Jobs\Notifications\SendPushNotification;
use App\Transformers\Requests\TripRequestTransformer;

class DeliveryRequestController extends Controller
{
    // public function __construct(User $user,Database $database,RequestModel $requestmodel)
    // {
    //     $this->database = $database;
    //     $this->user = $user;
    //     $this->requestmodel = $requestmodel;
    // }
    public function ridesRequest() {
        $ongoing = RequestModel::with('userDetail','driverDetail')
            ->where('is_cancelled', false)
            ->where('is_completed', false)
            ->orderBy('created_at','DESC')->pluck('id');
        $settings = ThirdPartySetting::where('module', 'firebase')->pluck('value', 'name')->toArray();

        $firebaseConfig = (object) [
            'apiKey' => $settings['firebase_api_key'],
            'authDomain' => $settings['firebase_auth_domain'],
            'databaseURL' => $settings['firebase_database_url'],
            'projectId' => $settings['firebase_project_id'],
            'storageBucket' => $settings['firebase_storage_bucket'],
            'messagingSenderId' => $settings['firebase_messaging_sender_id'],
            'appId' => $settings['firebase_app_id'],
            'measurementId' => $settings['firebase_measurement_id'],
        ];
        return Inertia::render('pages/delivery_rides_request/index',[
            'zones' => Zone::active()->get(),
            'types' => VehicleType::active()->get(),
            'ongoing_rides' => $ongoing,
            'firebaseConfig' => $firebaseConfig,
            'enable_outstation' => get_settings('show_outstation_ride_feature') || get_settings('show_delivery_outstation_ride_feature'),
        ]);
    }

    public function viewDetails(RequestModel $requestmodel) {
        $requestmodel->stops = null;
        $rejected_drivers = $requestmodel->driverRejectedRequestDetail()->with('drivers')->get();
        $settings = ThirdPartySetting::where('module', 'firebase')->pluck('value', 'name')->toArray();
        $requestmodel = fractal($requestmodel, new TripRequestTransformer)->toArray();
        $firebaseConfig = (object) [
            'apiKey' => $settings['firebase_api_key'],
            'authDomain' => $settings['firebase_auth_domain'],
            'databaseURL' => $settings['firebase_database_url'],
            'projectId' => $settings['firebase_project_id'],
            'storageBucket' => $settings['firebase_storage_bucket'],
            'messagingSenderId' => $settings['firebase_messaging_sender_id'],
            'appId' => $settings['firebase_app_id'],
            'measurementId' => $settings['firebase_measurement_id'],
        ];
        if(get_map_settings('map_type') == "open_street_map"){
            return Inertia::render('pages/delivery_rides_request/open-view',
                [
                    'request' => $requestmodel['data'],
                    'service_location'=>null,
                    'pick_icon'=>asset('image/map/pickup.png'),
                    'drop_icon'=>asset('image/map/drop.png'),
                    'firebaseConfig'=>$firebaseConfig,
                ]);
        }
        $googleMapKey = get_map_settings('google_map_key'); // Retrieve the Google Map API key
        return Inertia::render('pages/delivery_rides_request/view',
                    [
                        'request' => $requestmodel['data'],
                        'rejected_drivers' => $rejected_drivers,
                        'service_location'=>null,
                        'pick_icon'=>asset('image/map/pickup.png'),
                        'drop_icon'=>asset('image/map/drop.png'),
                        'stop_icon'=>asset('image/map/stop.png'),
                        'googleMapKey'=>$googleMapKey,
                        'firebaseConfig'=>$firebaseConfig,
                    ]
        );
    }
    
    public function list(QueryFilterContract $queryFilter, Request $request)
    {
        $query = RequestModel::where('requests.transport_type', 'delivery')
            ->with('userDetail', 'driverDetail')
            ->orderBy('created_at', 'DESC');
    
        if (auth()->user()->hasRole('owner')) {
            // Retrieve the specific owner associated with the authenticated user
            $owner = auth()->user()->owner;
            $query = RequestModel::where('owner_id', $owner->id)
                ->orWhere('booked_by', auth()->user()->id)
                ->with('userDetail', 'driverDetail')
                ->orderBy('created_at', 'DESC');
        }
    
        $results = $queryFilter->builder($query)
            ->customFilter(new RequestFilter)
            ->paginate();
    
        // Convert each item to array to include appends
        $items = fractal($results->items(), new TripRequestTransformer)->toArray();
    
        // Explicitly convert results to array for appended attributes
        $results->setCollection(collect($results->items())->map(fn($item) => $item->toArray()));
    
        return response()->json([
            'results' => $results->items(),
            'paginator' => $results,
        ]);
    }
    public function driverFind(Driver $driver,Request $request)
    {
        $request = RequestModel::find($request->request_id);
        return response()->json([
            'successMessage' => 'Driver Found successfully',
            'driver' => $driver,
            'current_time' => get_converted_time(now(),$request->timezone),
        ]);
    }
    public function cancelRide(RequestModel $requestmodel) {
        $update_parms['is_cancelled'] = true;
        $update_parms['cancelled_at'] = date('Y-m-d H:i:s');
        $update_parms['cancel_method'] = 0;
        if($requestmodel->driver_id){
            Driver::where('id',$requestmodel->driver_id)->update(['available'=>true]);
        }
        if($requestmodel->driverDetail)
        {
            $notifiable_driver = $requestmodel->driverDetail->user;
            $title = custom_trans('trip_cancelled_by_user_title',[],$notifiable_driver->lang);
            $body = custom_trans('trip_cancelled_by_user_body',[],$notifiable_driver->lang);
            dispatch(new SendPushNotification($notifiable_driver,$title,$body));
        }
        $requestmodel->update($update_parms);

        return response()->json([
            'successMessage' => 'Trip Cancelled successfully',
            'request' => $requestmodel,
        ]);
    }
}
