<?php

namespace App\Http\Controllers;
use Inertia\Inertia;
use Illuminate\Http\Request;
use App\Models\Country;
use App\Transformers\CountryTransformer;
use App\Models\User;
use Carbon\Carbon;
use App\Models\Admin\GoodsType;

class DispatcherController extends Controller
{
    public function bookingRequest() {

        $query = Country::active()->get();

        $countries = fractal($query, new CountryTransformer);

        $result = json_decode($countries->toJson(),true);
        
        $default_country = Country::active()->where('code',get_settings('default_country_code_for_mobile_app'))->first();

        $firebaseSettings = [
            'firebase_api_key' => get_firebase_settings('firebase_api_key'),
            'firebase_auth_domain' => get_firebase_settings('firebase_auth_domain'),
            'firebase_database_url' => get_firebase_settings('firebase_database_url'),
            'firebase_project_id' => get_firebase_settings('firebase_project_id'),
            'firebase_storage_bucket' => get_firebase_settings('firebase_storage_bucket'),
            'firebase_messaging_sender_id' => get_firebase_settings('firebase_messaging_sender_id'),
            'firebase_app_id' => get_firebase_settings('firebase_app_id'),
            'firebase_measurement_id' => get_firebase_settings('firebase_measurement_id'),
        ];

        // dd($map_key);

        $default_dial_code = $default_country->dial_code;
        $default_flag = $default_country->flag;

        $app_for = config('app.app_for');

        if($app_for=='taxi' || $app_for=='delivery')
        {
            $transport_type_for_ride[] = $app_for;
        }else{

            $transport_type_for_ride = ['taxi','delivery'];

        }
        // @TODO check if the rental is enabled or not
        $ride_type_for_ride = ['regular','rental'];

        $goods_types = GoodsType::active()->get();

        $map_type = get_map_settings('map_type');

        if($map_type=="open_street_map")
        {

            
            return Inertia::render('pages/dispatch/open-dispatch',['countries'=>$result['data'],
            'default_dial_code'=>$default_dial_code,'default_flag'=>$default_flag,
            'default_lat'=>get_settings('default_latitude'),'default_lng'=>get_settings('default_longitude'),
            'transport_type_for_ride'=>$transport_type_for_ride,'firebaseSettings'=>$firebaseSettings,
            'ride_type_for_ride'=>$ride_type_for_ride,'goodsTypes'=>$goods_types
            ]);   

        }else{
            $map_key = get_map_settings('google_map_key');


            return Inertia::render('pages/dispatch/index',['countries'=>$result['data'],
            'default_dial_code'=>$default_dial_code,'default_flag'=>$default_flag,
            'default_lat'=>get_settings('default_latitude'),'default_lng'=>get_settings('default_longitude'),
            'transport_type_for_ride'=>$transport_type_for_ride,'firebaseSettings'=>$firebaseSettings,
            'ride_type_for_ride'=>$ride_type_for_ride,'goodsTypes'=>$goods_types,'map_key'=>$map_key
            ]);

    
         }
    }



    /**
     * Fetch User Detail
     * 
     * 
     * */
    public function fetchUserIfExists()
    {
        $mobile = request()->mobile;

        //belongsTorole('user')->
        $user = User::where('mobile',$mobile)->first();
        
        return $this->respondSuccess($user);


    }
}
