<?php

namespace App\Http\Controllers;
use Inertia\Inertia;
use Illuminate\Support\Facades\Validator;
use App\Base\Filters\Master\CommonMasterFilter;
use App\Base\Libraries\QueryFilter\QueryFilterContract;
use App\Http\Controllers\Web\BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\Admin\InvoiceConfiguration;
use App\Base\Services\ImageUploader\ImageUploaderContract;
use App\Base\Services\ImageUploader\ImageUploader;
use DB;
use Auth;
use Session;
use Illuminate\Support\Facades\Storage;
use App\Models\Admin\NotificationChannel;
use App\Models\User;
use App\Models\Admin\NotificationChannelTranslation;

class NotificationChannelController extends Controller
{

    protected $imageUploader;

    protected $notification;

 

    public function __construct(NotificationChannel $notification, ImageUploaderContract $imageUploader)
    {
        $this->notification = $notification;
        $this->imageUploader = $imageUploader;
    }
   
    public function index() {
        return Inertia::render('pages/notification_channel/index');
       
    } 
    public function list(Request $request)
    {
        // $query = NotificationChannel::with('notificationChannelTranslationWords')->paginate();
        $query = NotificationChannel::with('notificationChannelTranslationWords')->orderBy('created_at','DESC')->paginate();
        // dd( $query);

        return response()->json([
            'results' => $query->items(),
            'paginator' => $query,
        ]);
    }
    public function edit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }

    public function signupEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/signup_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }
    
    public function forgotPasswordEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/forgot_password_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }

   
    public function userInvoiceEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/user_invoice_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }
    
    public function userRideLaterEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/user_rideLater_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }
    public function userReferralEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/user_referral_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }

    public function userWalletEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/user_wallet_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }

    public function userTransferAmountEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/user_amount_transfer_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }
    
    public function driverReferralEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/driver_referral_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }

    public function driverWalletEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/driver_wallet_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }

    public function driverTransferAmountEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/driver_amount_transfer_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }
    public function driverAccountApprovalEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/driver_account_approval_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }

    public function driverAccountDisapprovalEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/driver_account_disapprove_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }

    public function driverWithdrawalApprovalEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/driver_withdrawal_approval_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }
    public function driverWithdrawalDeclineEdit($id)
    {

        $notification = NotificationChannel::find($id);
        $languageFields = [];

        foreach ($notification->notificationChannelTranslationWords as $language) {
            $languageFields[$language->locale] = [
                'email_subject' => $language->email_subject,
                'mail_body' => $language->mail_body,
                'button_name' => $language->button_name,
                'footer_content' => $language->footer_content,
                'footer_copyrights' => $language->footer_copyrights,
                'notification_channel_id' => $notification->id,
            ];
        }
        $notification->languageFields = $languageFields ?? null;

        return Inertia::render(
            'pages/notification_channel/driver_withdrawal_decline_edit',
            ['notification' => $notification,'app_for'=>env('APP_FOR'),]
        );
    }
    public function update(Request $request, NotificationChannel $notification,)
    {
        // dd($request);
        // dd($notification);
        //  Validate the incoming request
         $validated = $request->validate([
            'email_subject' => 'required',
            'logo_img' => 'required',
            'mail_body' => 'required',
            'button_name' => 'required',
            'button_url' => 'required',
            'show_button' =>'required',
            'show_img' => 'required',
            'show_fbicon' => 'required',
            'show_instaicon' => 'required',
            'show_twittericon' =>'required',
            'show_linkedinicon' => 'required',
            'banner_img' => 'required',
            'footer_content' => 'required',
            'footer_copyrights' => 'required',
            'footer_fblink' => 'required',
            'footer_instalink' => 'required',
            'footer_twitterlink' => 'required',
            'footer_linkedinlink' => 'required',
        ]);
        // dd($validated);

        $updated_params['email_subject'] = $validated['email_subject']['en'];
        $updated_params['mail_body'] = $validated['mail_body']['en'];
        $updated_params['button_name'] = $validated['button_name']['en'];
        $updated_params['footer_content'] = $validated['footer_content']['en'];
        $updated_params['footer_copyrights'] = $validated['footer_copyrights']['en'];
        
        $updated_params['button_url'] = $validated['button_url'];
        $updated_params['show_fbicon'] = $validated['show_fbicon'];
        $updated_params['show_button'] = $validated['show_button'];
        $updated_params['show_img'] = $validated['show_img'];
        $updated_params['show_instaicon'] = $validated['show_instaicon'];
        $updated_params['show_twittericon'] = $validated['show_twittericon'];
        $updated_params['show_linkedinicon'] = $validated['show_linkedinicon'];

        if ($uploadedFile = $request->file('banner_img')) {
            $updated_params['banner_img'] = $this->imageUploader->file($uploadedFile)
                ->saveEmailTemplateImage();
        }
        if ($uploadedFile = $request->file('logo_img')) {
            $updated_params['logo_img'] = $this->imageUploader->file($uploadedFile)
                ->saveEmailTemplateImage();
        }

        $updated_params['footer'] = [
            'footer_fblink' => $validated['footer_fblink'],
            'footer_instalink' => $validated['footer_instalink'],
            'footer_twitterlink' => $validated['footer_twitterlink'],
            'footer_linkedinlink' => $validated['footer_linkedinlink'],
        ];

        // $notification->where('id', $request->id)->update($updated_params);
        $notification->notificationChannelTranslationWords()->delete();
        // dd($updated_params);


        $notification->update($updated_params);
        $translationData = [];
        $translations_data = [];
        foreach ($validated['email_subject'] as $code => $language) {
            $translationData[] = [
                'email_subject' => $language,
                'mail_body' => $validated['mail_body'][$code] ?? '',
                'button_name' => $validated['button_name'][$code] ?? '',
                'footer_content' => $validated['footer_content'][$code] ?? '',
                'footer_copyrights' => $validated['footer_copyrights'][$code] ?? '',
                'locale' => $code,
                'notification_channel_id' => $notification->id,
            ];
            $translations_data[$code] = new \stdClass();
            $translations_data[$code]->locale = $code;
            $translations_data[$code]->email_subject = $language; // Use the string value directly
            $translations_data[$code]->mail_body = $validated['mail_body'][$code]; // Fetch corresponding value
            $translations_data[$code]->button_name = $validated['button_name'][$code];
            $translations_data[$code]->footer_content = $validated['footer_content'][$code];
            $translations_data[$code]->footer_copyrights = $validated['footer_copyrights'][$code];
        }
        $notification->notificationChannelTranslationWords()->insert($translationData);
        $notification->translation_dataset = json_encode($translations_data);
        $notification->save();

        // Optionally, return a response
        return response()->json([
            'successMessage' => 'Mail Template updated successfully.',
            'notification' => $notification,
        ], 201);

    }

    public function updateStatus(Request $request)
{

    NotificationChannel::where('id', $request->id)
        ->update([
            'push_notification' => $request->push_notification,
            'mail' => $request->mail,
            'sms' => $request->sms,
        ]);

    return response()->json([
        'successMessage' => 'Status updated successfully',
    ]);
}



    
}
