<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Admin\VehicleType;
use Illuminate\Support\Facades\Log;
use App\Base\Libraries\QueryFilter\QueryFilterContract;
use App\Base\Filters\Admin\VehicleTypeFilter;
use App\Base\Services\ImageUploader\ImageUploaderContract;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\Api\V1\BaseController;
use Illuminate\Support\Facades\Storage;

class VehicleTypeController extends BaseController
{
    /**
     * The VehicleType model instance.
     *
     * @var \App\Models\Admin\VehicleType
     */
    protected $vehicle_type;

    protected $imageUploader;


    /**
     * VehicleTypeController constructor.
     *
     * @param \App\Models\Admin\VehicleType $vehicle_type
     */

    public function __construct(VehicleType $vehicle_type, ImageUploaderContract $imageUploader)
    {
        $this->vehicle_type = $vehicle_type;
        $this->imageUploader = $imageUploader;
    }

    public function index()
    {
        return Inertia::render('pages/vehicle_type/index');
    }


    // List of Vehicle Type
    public function list(QueryFilterContract $queryFilter, Request $request)
    {
        $query = VehicleType::with('vehicleTypeTranslationWords')->orderBy('created_at','DESC');
        // dd("ssss");
        $results = $queryFilter->builder($query)->customFilter(new VehicleTypeFilter)->paginate();

        return response()->json([
            'results' => $results->items(),
            'paginator' => $results,
        ]);
    }
    public function create()
    {

        return Inertia::render('pages/vehicle_type/create',['serviceLocation' => null]);
    }
    public function store(Request $request)
    {
        if(env('APP_FOR') == 'demo'){
            return response()->json([
                'alertMessage' => 'You are not Authorized'
            ], 403);
        }
        // dd($request->all());
         // Validate the incoming request
         $validated = $request->validate([
            'name' => 'required',
            'icon_types_for' => 'required',
            'description' => 'required',
            'short_description' => 'required',
            'icon' => 'required',
        ]);

        $created_params = $request->only(['name','description','short_description','icon_types_for', 'trip_dispatch_type']);


        if ($uploadedFile = $request->file('icon')) {
            $created_params['icon'] = $this->imageUploader->file($uploadedFile)
                ->saveVehicleTypeImage();
        }
        $created_params['active'] = true;
        $created_params['is_taxi'] = $request->transport_type;

        // Map the form inputs to the database columns
        $created_params['capacity'] = $request->capacity;
        $created_params['size'] = $request->size;
        // dd($validated);


        // Create a new service location
        $vehicleType = VehicleType::create($created_params);

        // Optionally, return a response
        return response()->json([
            'successMessage' => 'Vehicle Type created successfully.',
            'vehicleType' => $vehicleType,
        ], 201);
    }
    public function edit($id)
    {

        $vehicleType = VehicleType::find($id);
        return Inertia::render(
            'pages/vehicle_type/create',
            ['vehicleType' => $vehicleType,]
        );
    }
    public function update(Request $request, VehicleType $vehicle_type)
    {
// dd($request);
        if(env('APP_FOR') == 'demo'){
            return response()->json([
                'alertMessage' => 'You are not Authorized'
            ], 403);
        }

         // Validate the incoming request
         $validated = $request->validate([
            'name' => 'required',
            'icon_types_for' => 'required',
            'description' => 'required',
            'short_description' => 'required',
        ]);

        $updated_params = $request->only(['name','description','short_description','transport_type','icon_types_for','trip_dispatch_type']);
        // $updated_params['name'] = $validated['languageFields']['en'];

        if($request->hasFile('icon')){
                if ($vehicle_type->icon) {
                    Storage::delete('public/' . $vehicle_type->icon);
                }
                if ($uploadedFile = $request->file('icon')) {
                    $updated_params['icon'] = $this->imageUploader->file($uploadedFile)
                        ->saveVehicleTypeImage();
                    }
            }
        $updated_params['active'] = true;

        // Map the form inputs to the database columns
        $updated_params['capacity'] = $request->capacity;
        $updated_params['is_taxi'] = $request->transport_type;

        $updated_params['size'] = $request->size;


        $vehicle_type->update($updated_params);

        $vehicle_type->vehicleTypeTranslationWords()->delete();
        // Optionally, return a response
        return response()->json([
            'successMessage' => 'Vehicle Type updated successfully.',
            'vehicle_type' => $vehicle_type,
        ], 201);

    }
    public function destroy(VehicleType $vehicle_type)
    {
        if(env('APP_FOR') == 'demo'){
            return response()->json([
                'alertMessage' => 'You are not Authorized'
            ], 403);
        }
        if($vehicle_type->zoneType()->exists()){
            $vehicle_type->zoneType()->delete();
        }
        $vehicle_type->delete();

        return response()->json([
            'successMessage' => 'Vehicle Type deleted successfully',
        ]);
    }   
    public function updateStatus(Request $request)
    {
        if(env('APP_FOR') == 'demo'){
            return response()->json([
                'alertMessage' => 'You are not Authorized'
            ], 403);
        }
        // dd($request->all());
        VehicleType::where('id', $request->id)->update(['active'=> $request->status]);

        return response()->json([
            'successMessage' => 'Vehicle Type status updated successfully',
        ]);


    }

}
