<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Admin\NotificationChannel;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class NotificationChannelSeeder extends Seeder
{
    
    public function run()
    { 
        $notification = NotificationChannel::first();
        // $userName = User::latest()->value('name') ?? 'User'; 

        if (!$notification) {
            // Seed the notification channels
            \DB::table('notification_channels')->insert([
                [
                    'id' => Str::uuid(),
                    'role' =>'user',
                    'topics' => 'Customer Registration',
                    'topics_content' => 'Choose how Customer will get notified about Sent notification on customer registration',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Hello {name} ',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '<p>Thank you for joining MI Softwares! We are thrilled to have you as a part of our community.</p>   
                                    <p>Our mission is to mobility. We hope that you will find our products\/services to be useful and enjoyable.</p>         
                                    <p>To get started, please take a few moments to explore our website and familiarize yourself with our offerings. If you have any questions or concerns, our customer support team is always here to help.</p>         
                                    <p>We look forward to working with you and providing you with a top-notch experience.</p>         
                                    <p>Best regards, </p>         
                                    <p>MI Softwares</p>',
                    'button_name' => 'Button',
                    'button_url' => 'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'show_img' => 1,
                    'banner_img' => 'profile-bg.jpg',                    
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]), 
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'user',
                    'topics' => 'New Customer Registration',
                    'topics_content' => 'Choose how Customer will get notified about Sent notification on customer registration',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Registration Mail',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '<p>Hello {name}</p>
                                    <p>Thank you for signing up with us, your trusted taxi app. Your registration was successful, and we are excited to have you on board.</p>
                                    <p>Your Account Details</p>
                                    <p>Email: {email}</p>
                                    <p>Mobile Number: {mobile}</p>
                                    <p>We are now ready to help you with your transportation needs! To get started, simply click the button below to log in to your account:</p> 
                                    <p>Best regards, </p>         
                                    <p>MI Softwares</p>',
                    'button_name'=>'Log in',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'show_img' => 1,
                    'banner_img' => 'profile-bg.jpg',                    
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'user',
                    'topics' => 'Forgot Password',
                    'topics_content' => 'Choose how Admin will get notified about Sent notification on forgot password',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Change Password Request',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>Change Password Request</p>
                                    <p>You recently requested to reset your password for your account. Click the button below to reset it.</p>
                                    <p>Best regards, </p>         
                                    <p>MI Softwares</p>',
                    'button_name'=>'Reset Password',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'show_img' => 1,
                    'banner_img' => 'profile-bg.jpg',                    
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'user',
                    'topics' => 'User Ride Later',
                    'topics_content' => 'Choose how Customer will get notified about Sent notification on ride later',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Driver Assigned For Ride',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>Your Ride Later Trip is Confirmed</p>
                                    <p>Thank You for Riding with us</p>
                                    <p>Your "ride later" trip has been successfully scheduled.</p>
                                    <p>Best regards, </p>         
                                    <p>MI Softwares</p>',
                    'button_name'=>'View Details',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg',                     
                    'show_img' => 1,                   
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'user',
                    'topics' => 'Invoice For End of the Ride User',
                    'topics_content' => 'Choose how Customer will get notified about Sent notification on invoice for the end of the ride',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Invoice For Ride',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>Thank You for Riding with us</p>
                                    <p>Here is the summary of your recent trip:</p>
                                    <p>Invoice Number: 123456</p>
                                    <p>Pick Location: sample location</p>
                                    <p>Drop Location: sample location</p>
                                    <p>Vehicle No: TN 52A 1234</p>
                                    <p>Date:  28/12/2024</p>
                                    <p>EMail : sample@gmail.com</p>
                                    <p>Best regards, </p>         
                                    <p>MI Softwares</p>',
                    'button_name'=>'Reset Password',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg',                      
                    'show_img' => 1,                 
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'user',
                    'topics' => 'User Referral',
                    'topics_content' => 'Choose how Customer will get notified about Sent notification on referral code',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Referral Code',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>Thanks you being a valued Customer! We are excited to offer you a referral code that you can share with your friends,
                                    family, or colleagues.</p>
                                    <p>When they use this referral code, they will receive a discount on their first ride, and you will earn rewards as well.</p>
                                    <p>Share this code with others, and start earning rewards today! The more you refer, the more you can earn!</p>
                                    <p>To use the referral code, simply share it with the person you refer,
                                     and they can enter it during the booking process on our app.</p>
                                     <p>Best regards, </p>         
                                    <p>MI Softwares</p>',

                    'button_name'=>'Share',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg', 
                    'show_img' => 1,                   
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'user',
                    'topics' => 'User Wallet Amount',
                    'topics_content' => 'Choose how Customer will get notified about Sent notification on wallet amount Adjusted',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Wallet Amount Adjusted',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>We are happy to inform you that an amount has been successfully Adjusted to your wallet.</p> 
                                    <p><strong>Transaction Details</strong></p>
                                    <p><strong>Transaction Id:</strong> {transaction_id}</p>
                                    <p><strong>Amount:</strong> {currency}{amount}</p>
                                    <p><strong>Current Balance:</strong>{currency}{current_balance}</p>
                                    <p>Best regards, </p>         
                                    <p>MI Softwares</p>',
                    'button_name'=>'View Details',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg',
                    'show_img' => 1,                    
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'user',
                    'topics' => 'User Amount Transfer',
                    'topics_content' => 'Choose how Customer will get notified about Sent notification on amount transfer',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Wallet Amount Transfer',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>We are writing to confirm that you have successfully transferred an amount from your wallet.</p>
                                    <p><strong>Transaction Details</strong></p>
                                    <p><strong>Transaction Id:</strong> {transaction_id}</p>
                                    <p><strong>Amount:</strong> {currency}{amount}</p>
                                    <p><strong>Current Balance:</strong>{currency}{current_balance}</p>
                                    <p>If you did not initiate this transfer, please contact our support team immediately.</p>
                                    <p>Thank you for using our services!</p>
                                    <p>Best regards, </p>         
                                    <p>MI Softwares</p>',
                    'button_name'=>'View Details',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg',    
                    'show_img' => 1,                
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'driver',
                    'topics' => 'Driver Referral',
                    'topics_content' => 'Choose how Driver will get notified about Sent notification on referral code',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Referral Code',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>Thanks you being a valued Driver! We are excited to offer you a referral code that you can share with your friends,
                                    family, or colleagues.</p>
                                    <p>When they use this referral code, they will receive a discount on their first ride, and you will earn rewards as well.</p>
                                    <p>Share this code with others, and start earning rewards today! The more you refer, the more you can earn!</p>
                                    <p>To use the referral code, simply share it with the person you refer,
                                     and they can enter it during the booking process on our app.</p>
                                     <p>Best regards, </p>         
                                    <p>MI Softwares</p>',

                    'button_name'=>'Share',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg', 
                    'show_img' => 1,                   
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'driver',
                    'topics' => 'Driver Account Approval',
                    'topics_content' => 'Choose how Driver will get notified about Sent notification on account approval',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Account Approval',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Congratulations,{name} </p>
                                    <p>We are  to inform you that your driver account  has been successfully approved. You are now ready to start accepting ride requests and earning..</p>   
                                    <p>Please log in to your account using the credentials provided during registration. If you encounter any issues, feel free to reach out to our support team.</p>        
                                    <p>Best regards, </p>         
                                    <p>MI Softwares</p>',
                    'button_name' => 'Button',
                    'button_url' => 'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg', 
                    'show_img' => 1,                   
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]), 
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'driver',
                    'topics' => 'Driver Account Disapproval',
                    'topics_content' => 'Choose how Driver will get notified about Sent notification on account disapproval',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Account Disapproval',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p> We regret to inform you that your application to become a driver with our taxi service has not been approved at this time.</p>   
                                    <p>If you have any questions or need further clarification, feel free to contact our support team.</p>        
                                    <p>Best regards, </p>         
                                    <p>MI Softwares</p>',
                    'button_name' => 'Button',
                    'button_url' => 'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg', 
                    'show_img' => 1,                   
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]), 
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'driver',
                    'topics' => 'Driver Wallet Amount',
                    'topics_content' => 'Choose how Driver will get notified about Sent notification on wallet amount Adjusted',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Wallet Amount Adjusted',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>We are happy to inform you that an amount has been successfully Adjusted to your wallet.</p>  
                                    <p><strong>Transaction Details</strong></p>
                                    <p><strong>Transaction Id:</strong> {transaction_id}</p>
                                    <p><strong>Amount:</strong> {currency}{amount}</p>
                                    <p><strong>Current Balance:</strong>{currency}{current_balance}</p>
                                    <p>Best regards, </p>         
                                    <p>MI Softwares</p>',
                    'button_name'=>'View Details',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg', 
                    'show_img' => 1,                   
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'driver',
                    'topics' => 'Driver Amount Transfer',
                    'topics_content' => 'Choose how Driver will get notified about Sent notification on amount transfer',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Amount Transfer',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>We are writing to confirm that you have successfully transferred an amount from your wallet.</p>                                    
                                    <p><strong>Transaction Details</strong></p>
                                    <p><strong>Transaction Id:</strong> {transaction_id}</p>
                                    <p><strong>Amount:</strong> {currency}{amount}</p>
                                    <p><strong>Current Balance:</strong>{currency}{current_balance}</p>
                                    <p>If you did not initiate this transfer, please contact our support team immediately.</p>
                                    <p>Thank you for using our services!</p>',
                    'button_name'=>'View Details',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg',        
                    'show_img' => 1,            
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'driver',
                    'topics' => 'Driver Withdrawal Request Approval',
                    'topics_content' => 'Choose how Driver will get notified about Sent notification on request approval',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Withdrawal Request Approval',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>  Your withdrawal request has been approved. Here are the details:.</p>                                    
                                    <p><strong>Transaction Details</strong></p>
                                    <p><strong>Transaction Id:</strong> {transaction_id}</p>
                                    <p><strong>Amount:</strong> {currency}{amount}</p>
                                    <p><strong>Current Balance:</strong>{currency}{current_balance}</p>
                                    <p>If you have any issues with payment, kindly reply to this email or send an email to support@gmail.com</p>
                                    <p>Thank you for using our services!</p>',
                    'button_name'=>'View Details',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg', 
                    'show_img' => 1,                   
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],
                [
                    'id' => Str::uuid(),
                    'role' =>'driver',
                    'topics' => 'Driver Withdrawal Request Decline',
                    'topics_content' => 'Choose how Driver will get notified about Sent notification on request decline',
                    'push_notification' => 1,
                    'mail' => 1,
                    'sms' => 1,
                    'email_subject' => 'Withdrawal Request Decline',
                    'logo_img' => 'logo-light.png',
                    'mail_body' => '
                                    <p>Hello {name}</p>
                                    <p>Unfortunately, your withdrawal request has been declined.</p>   
                                    <p>If you have any issues with payment, kindly reply to this email or send an email to support@gmail.com</p>
                                    <p>Thank you for using our services!</p>',
                    'button_name'=>'View Details',
                    'button_url'=>'https://play.google.com/store/apps/details?id=tagxi.bidding.user',
                    'show_button' => 1,
                    'banner_img' => 'profile-bg.jpg',   
                    'show_img' => 1,                 
                    'footer_content' => '<p>If you have any queries , Please email us support@gmail.com.They will answer the question and help you out.</p>',
                    'footer_copyrights' => '2021 Misoftwares & Rights Reserved',
                    'show_fbicon' => 1,
                    'show_instaicon' => 1,
                    'show_twittericon' => 1,
                    'show_linkedinicon' => 1,
                    'footer' => json_encode([
                        'footer_fblink' => 'https://www.facebook.com/',
                        'footer_instalink' => 'https://www.instagram.com/',
                        'footer_twitterlink' => 'https://x.com/',
                        'footer_linkedinlink' => 'https://in.linkedin.com/'
                    ]),
                    
                ],

            ]);
        }

    //     // Insert translations
        $notificationChannels = \DB::table('notification_channels')->get();

                    foreach ($notificationChannels as $channelData) 
            {
                // Check if the notification channel already exists based on a unique attribute (like 'email_subject')
                $notificationChannel = NotificationChannel::where('topics', $channelData->topics)->first();

                if ($notificationChannel) {
                    // Update existing notification channel
                    // $notificationChannel->update($channelData);
                    $notificationChannel->update((array) $channelData);

                    // Delete old translations for the notification channel
                    $notificationChannel->notificationChannelTranslationWords()->delete();
                } else {
                    // Create new notification channel if it doesn't exist
                    // $notificationChannel = NotificationChannel::create($channelData);
                    $notificationChannel = NotificationChannel::create((array) $channelData);
                }

                // Prepare translation data for the 'en' locale
                $translationData = [
                    'email_subject' => $channelData->email_subject,
                    'mail_body' => $channelData->mail_body,
                    'button_name' => $channelData->button_name,
                    'footer_content' => $channelData->footer_content,
                    'footer_copyrights' => $channelData->footer_copyrights,
                    'locale' => 'en',
                    'notification_channel_id' => $notificationChannel->id,
                ];

                // Store the translations as objects for 'en' locale
                $translations_data['en'] = new \stdClass();
                $translations_data['en']->locale = 'en';
                $translations_data['en']->email_subject = $channelData->email_subject;
                $translations_data['en']->mail_body = $channelData->mail_body;
                $translations_data['en']->button_name = $channelData->button_name;
                $translations_data['en']->footer_content = $channelData->footer_content;
                $translations_data['en']->footer_copyrights = $channelData->footer_copyrights;

                // Insert the translation data into the related translation table
                $notificationChannel->notificationChannelTranslationWords()->create($translationData);

                // Store the translation dataset in JSON format for the notification channel
                $notificationChannel->translation_dataset = json_encode($translations_data);
                
                // Save the updated notification channel with its translations
                $notificationChannel->save();
            }

    }
}


