<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Admin\InvoiceConfiguration;
use App\Models\ThirdPartySetting;

class ThirdPartySettingSeeder extends Seeder
{

    protected $payment_settings = [
    //paymentoption
        ['name' => 'payment_option',
        'value' => 'cash,card,wallet',
        'module' => 'payment',
       ],
    //pastack
        ['name' => 'enable_paystack',
         'value' => '0',
         'module' => 'payment',
        ],
        ['name' => 'paystack_environment',
         'value' => 'test',
         'module' => 'payment',
        ],
        ['name' => 'paystack_test_secret_key',
         'value' => 'Your Paystack Test Secret Key',
         'module' => 'payment',
        ],
         ['name' => 'paystack_production_secret_key',
         'value' => 'Your Paystack Production Secret Key',
         'module' => 'payment',
        ],
        ['name' => 'paystack_test_publishable_key',
         'value' => 'Your Paystack Test Publish Key',
         'module' => 'payment',
        ],    
        ['name' => 'paystack_production_publishable_key',
         'value' => 'Your Paystack Production Publish Key',
         'module' => 'payment',
        ],
    //cashfree
        ['name' => 'enable_cashfree',
         'value' => '0',
         'module' => 'payment',
        ],
        ['name' => 'cash_free_environment',
         'value' => 'test',
         'module' => 'payment',
        ],
        ['name' => 'cash_free_secret_key',
         'value' => 'Enter Cashfree Test Secret Key',
         'module' => 'payment',
        ],
        ['name' => 'cash_free_production_secret_key',
         'value' => 'Enter Cashfree Production Secret Key',
         'module' => 'payment',
        ],           
         ['name' => 'cash_free_app_id',
         'value' => 'Enter Cashfree Test App ID',
         'module' => 'payment',
        ],
        ['name' => 'cash_free_production_app_id',
         'value' => 'Enter Cashfree Production App ID',
         'module' => 'payment',
        ],    
    //MERCADOPAGO
        ['name' => 'enable_mercadopago',
         'value' => '0',
         'module' => 'payment',
        ],
        ['name' => 'mercadopago_environment',
         'value' => 'test',
         'module' => 'payment',
        ],
        ['name' => 'mercadopago_test_public_key',
         'value' => 'Enter Mercadopago Test Secret Key',
         'module' => 'payment',
        ],
        ['name' => 'mercadopago_live_public_key',
         'value' => 'Enter Mercadopago Production Secret Key',
         'module' => 'payment',
        ],         
        ['name' => 'mercadopago_test_access_token',
         'value' => 'Enter Mercadopago Test Access Token',
         'module' => 'payment',
        ],           
        ['name' => 'mercadopago_live_access_token',
         'value' => 'Enter Mercadopago Production Access Token',
         'module' => 'payment',
        ],
    //STRIPE
        ['name' => 'enable_stripe',
         'value' => '0',
         'module' => 'payment',
        ],
        ['name' => 'stripe_environment',
         'value' => 'test',
         'module' => 'payment',
        ],
        ['name' => 'stripe_test_secret_key',
         'module' => 'payment','value' => 'Enter Stripe Test Secret Key',
        ],
        ['name' => 'stripe_live_secret_key',
         'module' => 'payment','value' => 'Enter Stripe Production Secret Key',
        ],         
        ['name' => 'stripe_test_publishable_key',
         'module' => 'payment','value' => 'Enter Stripe Test Publish Key',
        ],           
        ['name' => 'stripe_live_publishable_key',
         'module' => 'payment','value' => 'Enter Stripe Production Publish Key',
        ],   
    //FLUTTER-WAVE
        ['name' => 'enable_flutter_wave',
         'value' => '0',
         'module' => 'payment',
        ],
        ['name' => 'flutter_wave_environment',
         'value' => 'test',
         'module' => 'payment',
        ],
        ['name' => 'flutter_wave_test_secret_key',
         'value' => 'Enter Flutter-Wave Test Public Key',
         'module' => 'payment',
        ],
        ['name' => 'flutter_wave_production_secret_key',
         'value' => 'Enter Flutter-Wave Live Public Key',
         'module' => 'payment',
        ],  
    //RAZOR PAY
        ['name' => 'enable_razor_pay',
         'value' => '0',
         'module' => 'payment',
        ],
        ['name' => 'razor_pay_environment',
         'value' => 'test',
         'module' => 'payment',
        ],
        ['name' => 'razor_pay_test_api_key',
         'value' => 'Enter Razor Pay Test Api Key',
         'module' => 'payment',
        ],
        ['name' => 'razor_pay_live_api_key',
         'value' => 'Enter Razor Pay Live Api Key',
         'module' => 'payment',
        ],
        ['name' => 'razor_pay_secrect_key',
         'value' => 'Enter Razor Pay Secrect key',
         'module' => 'payment',
        ],
        ['name' => 'razor_pay_test_secrect_key',
         'value' => 'Enter Razor pay Test Secrect Key',
         'module' => 'payment',
        ],
    //KHALTI PAY 
        ['name' => 'enable_khalti_pay',
         'value' => '0',
         'module' => 'payment',
        ],
        ['name' => 'khalti_pay_environment',
         'value' => 'test',
         'module' => 'payment',
        ],
        ['name' => 'khalti_pay_test_api_key',
         'value' => 'Enter Khalti Pay Test Secret Key',
         'module' => 'payment',
        ],
        ['name' => 'khalti_pay_live_api_key',
         'value' => 'Enter Khalti Pay Live Secret Key',
         'module' => 'payment',
        ],     
//mail Config
        ['name' => 'mail_mailer',
         'value' => 'smtp',
         'module' => 'mail_config',
        ],  
        ['name' => 'mail_host',
         'value' => 'smtp.gmail.com',
         'module' => 'mail_config',
        ],    
        ['name' => 'mail_port',
         'value' => '587',
         'module' => 'mail_config',
        ], 
        ['name' => 'mail_username',
         'value' => 'misoftwares2021@gmail.com',
         'module' => 'mail_config',
        ], 
        ['name' => 'mail_password',
         'value' => 'lsnvldfnsdfkvdf',
         'module' => 'mail_config',
        ], 
        ['name' => 'mail_encryption',
         'value' => 'tls',
         'module' => 'mail_config',
        ],       
        ['name' => 'mail_from_address',
         'value' => 'misoftwares2021@gmail.com',
         'module' => 'mail_config',
        ],  
        ['name' => 'mail_from_name',
         'value' => 'misoftwares',
         'module' => 'mail_config',
        ],        
//map settings
        ['name' => 'map_type',
        'value' => 'google_map',
        'module' => 'map',
        ], 
        ['name' => 'enable_vase_map',
         'value' => '1',
         'module' => 'map',
        ], 
        ['name' => 'google_map_key',
         'value' => 'Your Google Map Key',
         'module' => 'map',
        ], 
        // ['name' => 'google_map_key_for_distance_matrix',
        //  'value' => 'your_map_key',
        //  'module' => 'map',
        // ], 
        // ['name' => 'google_sheet_id',
        //  'value' => '1sOIs6oiLv-xrc3cNq2rvOv9ItXoux2MZJE_gdnBT7co',
        //  'module' => 'map',
        // ],  
//firebase setting
        ['name' => 'firebase_database_url',
         'value' => 'https://your-db.firebaseio.com',
         'module' => 'firebase',
        ], 
        ['name' => 'firebase_api_key',
         'value' => 'your-api-key',
         'module' => 'firebase',
        ], 
        ['name' => 'firebase_auth_domain',
         'value' => 'your-auth-domain',
         'module' => 'firebase',
        ], 
        ['name' => 'firebase_project_id',
         'value' => 'your-firebase-project-id',
         'module' => 'firebase',
        ],      
        ['name' => 'firebase_storage_bucket',
         'value' => 'your-firebase-storage-bucket',
         'module' => 'firebase',
        ], 
        ['name' => 'firebase_messaging_sender_id',
         'value' => 'your-firebase-messaging-sender-id',
         'module' => 'firebase',
        ], 
        ['name' => 'firebase_app_id',
         'value' => 'your-app-id',
         'module' => 'firebase',
        ], 
        ['name' => 'firebase_measurement_id',
         'value' => 'kkkkk',
         'module' => 'firebase',
        ], 
    //recaptcha
        ['name' => 'reacptcha_site_key',
         'value' => 'your-recaptcha-site-key',
         'module' => 'recaptcha',
        ], 
        ['name' => 'reacptcha_secret_key',
         'value' => 'your-recaptcha-secret-key',
         'module' => 'recaptcha',
        ], 
        ['name' => 'enable_recaptcha',
         'value' => '0',
         'module' => 'recaptcha',
        ], 
//sms
        ['name' => 'enable_firebase_otp',
         'value' => '0',
         'module' => 'sms',
        ],  
    //twilio       
        ['name' => 'enable_twilio',
         'value' => '0',
         'module' => 'sms',
        ], 
        ['name' => 'twilio_sid',
         'value' => '0',
         'module' => 'sms',
        ], 
        ['name' => 'twilio_token',
         'value' => 'Your Twilio Token',
         'module' => 'sms',
        ], 
        ['name' => 'twilio_from_number',
         'value' => 'Your Twilio Mobile Number',
         'module' => 'sms',
        ],         
   // sparrow               
        ['name' => 'enable_sparrow',
         'value' => '1',
         'module' => 'sms',
        ], 
        ['name' => 'sparrow_sender_id',
         'value' => 'Your Sparrow Sender ID',
         'module' => 'sms',
        ], 
        ['name' => 'sparrow_token',
         'value' => 'Your Sparrow Token',
         'module' => 'sms',
        ],  
//msg91
        ['name' => 'enable_msg91',
         'value' => '0',
         'module' => 'sms',
        ],  
        ['name' => 'msg91_template_id',
         'value' => 'Your MSG91 Template ID',
         'module' => 'sms',
        ],  
        ['name' => 'msg91_auth_key',
         'value' => 'Your MSG91 Token',
         'module' => 'sms',
        ],                  
    // smsala
        ['name' => 'enable_sms_ala',
         'value' => '0',
         'module' => 'sms',
        ],      
        ['name' => 'smsala_api_key',
         'value' => 'Your SMS ALA Api Key',
         'module' => 'sms',
        ], 
        ['name' => 'smsala_secrect_key',
         'value' => 'Your SMS ALA Api Secret Key',
         'module' => 'sms',
        ], 
        ['name' => 'smsala_token',
         'value' => 'Your SMS ALA Token',
         'module' => 'sms',
        ], 
        ['name' => 'smsala_from_number',
         'value' => 'Your SMS ALA Mobile Number',
         'module' => 'sms',
        ]
    ];

    protected $invoice_configuration = [
        //invoice configuration
        ['name' => 'invoice_logo',
        'value' => 'rest.png',
        'module' => 'invoice_configuration',
        ], 
        ['name' => 'privacy_policy_link',
        'value' => 'Test',
        'module' => 'invoice_configuration',
        ], 
        ['name' => 'terms_and_conditions_link',
        'value' => 'https://test-server.ondemandappz.com/terms',
        'module' => 'invoice_configuration',
        ], 
        ['name' => 'invoice_email',
        'value' => 'dilip@misoftwares.com',
        'module' => 'invoice_configuration',
        ],
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $created_params = $this->payment_settings;


          foreach ($created_params as $third_party_setting) 
          {
            if(!ThirdPartySetting::where('name',$third_party_setting['name'])->exists()){
                ThirdPartySetting::create($third_party_setting);
            }
          }
      
        $created_param = $this->invoice_configuration;

        $value = InvoiceConfiguration::first();
        if(is_null($value))
        {
          foreach ($created_param as $invoice_configuration) 
          {
            InvoiceConfiguration::create($invoice_configuration);
          }
        }else {
          foreach ($created_param as $invoice_configuration) 
          {
            $value->update($invoice_configuration);
          }
        }
    }
}
