import { DrawingSeries } from "./DrawingSeries";
import { color } from "../../../core/util/Color";
export class DoodleSeries extends DrawingSeries {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "_panX", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_panY", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        // point index in segment
        Object.defineProperty(this, "_pIndex", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(this, "_tag", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "doodle"
        });
        Object.defineProperty(this, "_down", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
    }
    _afterNew() {
        super._afterNew();
        this.setPrivate("allowChangeSnap", false);
        this.bullets.clear();
        this.strokes.template.setAll({
            fill: color(0xffffff),
            fillOpacity: 0
        });
    }
    _handlePointerMove(event) {
        super._handlePointerMove(event);
        if (this._drawingEnabled && this._isPointerDown) {
            this._handleBulletPosition(event);
        }
    }
    _handleBulletPosition(event) {
        const chart = this.chart;
        if (chart) {
            const xAxis = this.get("xAxis");
            const yAxis = this.get("yAxis");
            const point = chart.plotContainer.toLocal(event.point);
            const valueX = this._getXValue(xAxis.positionToValue(xAxis.coordinateToPosition(point.x)));
            const valueY = this._getYValue(yAxis.positionToValue(yAxis.coordinateToPosition(point.y)), valueX);
            const index = this._index;
            this.data.push({ valueY: valueY, valueX: valueX, index: index, corner: this._pIndex, drawingId: this._drawingId });
            const len = this.dataItems.length;
            const dataItem = this.dataItems[len - 1];
            this._setXLocation(dataItem, valueX);
            this._pIndex++;
            this.setPrivate("startIndex", 0);
            this.setPrivate("endIndex", len);
        }
    }
    _handlePointerDown(event) {
        const chart = this.chart;
        if (chart) {
            if (this.unselectAllDrawings() == 0) {
                super._handlePointerDown(event);
                this._increaseIndex();
                this._pIndex = 0;
                this._panX = chart.get("panX");
                this._panY = chart.get("panY");
                chart.set("panX", false);
                chart.set("panY", false);
                const cursor = chart.get("cursor");
                if (cursor) {
                    cursor.setPrivate("visible", false);
                }
                this._down = true;
                this.data.push({ stroke: this._getStrokeTemplate(), sprite: this.mainContainer, index: this._index, corner: this._pIndex, drawingId: this._drawingId });
            }
        }
    }
    _handlePointerUp(event) {
        super._handlePointerUp(event);
        const chart = this.chart;
        if (chart && this._down) {
            this._down = false;
            this.setTimeout(() => {
                chart.set("panX", this._panX);
                chart.set("panY", this._panY);
                const cursor = chart.get("cursor");
                if (cursor) {
                    cursor.setPrivate("visible", true);
                }
            }, 100);
            this._dispatchStockEvent("drawingadded", this._drawingId, this._index);
        }
    }
}
Object.defineProperty(DoodleSeries, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "DoodleSeries"
});
Object.defineProperty(DoodleSeries, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: DrawingSeries.classNames.concat([DoodleSeries.className])
});
//# sourceMappingURL=DoodleSeries.js.map