import { SimpleLineSeries } from "./SimpleLineSeries";
export class VerticalLineSeries extends SimpleLineSeries {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "_tag", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "vertical"
        });
    }
    _afterNew() {
        super._afterNew();
        this.lines.template.set("forceHidden", true);
    }
    _handleBulletDragged(event) {
        super._handleBulletDragged(event);
        const dataItem = event.target.dataItem;
        const dataContext = dataItem.dataContext;
        if (dataContext) {
            const index = dataContext.index;
            const diP1 = this._di[index]["p1"];
            const diP2 = this._di[index]["p2"];
            const diP3 = this._di[index]["p3"];
            const movePoint = this._movePointerPoint;
            if (diP1 && diP2 && diP3 && movePoint) {
                const yAxis = this.get("yAxis");
                const xAxis = this.get("xAxis");
                const valueX = this._getXValue(xAxis.positionToValue(xAxis.coordinateToPosition(movePoint.x)));
                const valueY = this._getYValue(yAxis.positionToValue(yAxis.coordinateToPosition(movePoint.y)), valueX);
                const min = yAxis.getPrivate("min", 0);
                const max = yAxis.getPrivate("max", 1);
                this._setContext(diP1, "valueY", min - (max - min) * 10, true);
                this._setContext(diP2, "valueY", valueY, true);
                this._setContext(diP3, "valueY", max + (max - min) * 10, true);
                this._setContext(diP1, "valueX", valueX);
                this._setContext(diP2, "valueX", valueX);
                this._setContext(diP3, "valueX", valueX);
                this._setXLocation(diP1, valueX);
                this._setXLocation(diP2, valueX);
                this._setXLocation(diP3, valueX);
                this._positionBullets(diP1);
                this._positionBullets(diP2);
                this._positionBullets(diP3);
            }
        }
    }
    _updateSegment(index) {
        if (this._di[index]) {
            const diP1 = this._di[index]["p1"];
            const diP3 = this._di[index]["p3"];
            if (diP1 && diP3) {
                const yAxis = this.get("yAxis");
                const min = yAxis.getPrivate("min", 0);
                const max = yAxis.getPrivate("max", 1);
                this._setContext(diP1, "valueY", min - (max - min) * 10, true);
                this._setContext(diP3, "valueY", max + (max - min) * 10, true);
            }
        }
    }
    _handlePointerMoveReal() {
    }
    _handlePointerClickReal(event) {
        if (this._drawingEnabled) {
            if (!this._isDragging) {
                if (this.unselectAllDrawings() == 0) {
                    this._increaseIndex();
                    this._addPoints(event, this._index);
                    this.isDrawing(false);
                    this._hideResizer();
                    this._updateSegment(this._index);
                    this._dispatchStockEvent("drawingadded", this._drawingId, this._index);
                }
            }
        }
    }
    _addPointsReal(valueX, valueY, index) {
        super._addPointsReal(valueX, valueY, index);
        this._addPoint(valueX, valueY, "p3", index);
    }
}
Object.defineProperty(VerticalLineSeries, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "VerticalLineSeries"
});
Object.defineProperty(VerticalLineSeries, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: SimpleLineSeries.classNames.concat([VerticalLineSeries.className])
});
//# sourceMappingURL=VerticalLineSeries.js.map