import type { IIndicatorEditableSetting } from "./Indicator";
import { ChartIndicator, IChartIndicatorSettings, IChartIndicatorPrivate, IChartIndicatorEvents } from "./ChartIndicator";
import { LineSeries } from "../../xy/series/LineSeries";
import type { DataItem } from "../../../..";
export interface IAverageTrueRangeSettings extends IChartIndicatorSettings {
}
export interface IAverageTrueRangePrivate extends IChartIndicatorPrivate {
}
export interface IAverageTrueRangeEvents extends IChartIndicatorEvents {
}
/**
 * An implementation of a [[StockChart]] indicator.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/stock/indicators/} for more info
 */
export declare class AverageTrueRange extends ChartIndicator {
    static className: string;
    static classNames: Array<string>;
    _settings: IAverageTrueRangeSettings;
    _privateSettings: IAverageTrueRangePrivate;
    _events: IAverageTrueRangeEvents;
    /**
     * Indicator series.
     */
    series: LineSeries;
    _editableSettings: IIndicatorEditableSetting[];
    _afterNew(): void;
    _createSeries(): LineSeries;
    protected _getDataArray(dataItems: Array<DataItem<any>>): Array<any>;
    /**
     * @ignore
     */
    prepareData(): void;
}
//# sourceMappingURL=AverageTrueRange.d.ts.map