import { createVNode, mergeProps } from "vue";
export default {
  name: 'CpuIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-cpu"
    }, { ...attrs
    }), [createVNode("rect", {
      "x": "4",
      "y": "4",
      "width": "16",
      "height": "16",
      "rx": "2",
      "ry": "2"
    }), createVNode("rect", {
      "x": "9",
      "y": "9",
      "width": "6",
      "height": "6"
    }), createVNode("line", {
      "x1": "9",
      "y1": "1",
      "x2": "9",
      "y2": "4"
    }), createVNode("line", {
      "x1": "15",
      "y1": "1",
      "x2": "15",
      "y2": "4"
    }), createVNode("line", {
      "x1": "9",
      "y1": "20",
      "x2": "9",
      "y2": "23"
    }), createVNode("line", {
      "x1": "15",
      "y1": "20",
      "x2": "15",
      "y2": "23"
    }), createVNode("line", {
      "x1": "20",
      "y1": "9",
      "x2": "23",
      "y2": "9"
    }), createVNode("line", {
      "x1": "20",
      "y1": "14",
      "x2": "23",
      "y2": "14"
    }), createVNode("line", {
      "x1": "1",
      "y1": "9",
      "x2": "4",
      "y2": "9"
    }), createVNode("line", {
      "x1": "1",
      "y1": "14",
      "x2": "4",
      "y2": "14"
    })]);
  }

};