import { createVNode, mergeProps } from "vue";
export default {
  name: 'LifeBuoyIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-life-buoy"
    }, { ...attrs
    }), [createVNode("circle", {
      "cx": "12",
      "cy": "12",
      "r": "10"
    }), createVNode("circle", {
      "cx": "12",
      "cy": "12",
      "r": "4"
    }), createVNode("line", {
      "x1": "4.93",
      "y1": "4.93",
      "x2": "9.17",
      "y2": "9.17"
    }), createVNode("line", {
      "x1": "14.83",
      "y1": "14.83",
      "x2": "19.07",
      "y2": "19.07"
    }), createVNode("line", {
      "x1": "14.83",
      "y1": "9.17",
      "x2": "19.07",
      "y2": "4.93"
    }), createVNode("line", {
      "x1": "14.83",
      "y1": "9.17",
      "x2": "18.36",
      "y2": "5.64"
    }), createVNode("line", {
      "x1": "4.93",
      "y1": "19.07",
      "x2": "9.17",
      "y2": "14.83"
    })]);
  }

};