import { createVNode, mergeProps } from "vue";
export default {
  name: 'LoaderIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-loader"
    }, { ...attrs
    }), [createVNode("line", {
      "x1": "12",
      "y1": "2",
      "x2": "12",
      "y2": "6"
    }), createVNode("line", {
      "x1": "12",
      "y1": "18",
      "x2": "12",
      "y2": "22"
    }), createVNode("line", {
      "x1": "4.93",
      "y1": "4.93",
      "x2": "7.76",
      "y2": "7.76"
    }), createVNode("line", {
      "x1": "16.24",
      "y1": "16.24",
      "x2": "19.07",
      "y2": "19.07"
    }), createVNode("line", {
      "x1": "2",
      "y1": "12",
      "x2": "6",
      "y2": "12"
    }), createVNode("line", {
      "x1": "18",
      "y1": "12",
      "x2": "22",
      "y2": "12"
    }), createVNode("line", {
      "x1": "4.93",
      "y1": "19.07",
      "x2": "7.76",
      "y2": "16.24"
    }), createVNode("line", {
      "x1": "16.24",
      "y1": "7.76",
      "x2": "19.07",
      "y2": "4.93"
    })]);
  }

};