import { createVNode, mergeProps } from "vue";
export default {
  name: 'MicOffIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-mic-off"
    }, { ...attrs
    }), [createVNode("line", {
      "x1": "1",
      "y1": "1",
      "x2": "23",
      "y2": "23"
    }), createVNode("path", {
      "d": "M9 9v3a3 3 0 0 0 5.12 2.12M15 9.34V4a3 3 0 0 0-5.94-.6"
    }), createVNode("path", {
      "d": "M17 16.95A7 7 0 0 1 5 12v-2m14 0v2a7 7 0 0 1-.11 1.23"
    }), createVNode("line", {
      "x1": "12",
      "y1": "19",
      "x2": "12",
      "y2": "23"
    }), createVNode("line", {
      "x1": "8",
      "y1": "23",
      "x2": "16",
      "y2": "23"
    })]);
  }

};