import { createVNode, mergeProps } from "vue";
export default {
  name: 'ShuffleIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-shuffle"
    }, { ...attrs
    }), [createVNode("polyline", {
      "points": "16 3 21 3 21 8"
    }), createVNode("line", {
      "x1": "4",
      "y1": "20",
      "x2": "21",
      "y2": "3"
    }), createVNode("polyline", {
      "points": "21 16 21 21 16 21"
    }), createVNode("line", {
      "x1": "15",
      "y1": "15",
      "x2": "21",
      "y2": "21"
    }), createVNode("line", {
      "x1": "4",
      "y1": "4",
      "x2": "9",
      "y2": "9"
    })]);
  }

};