import { createVNode, mergeProps } from "vue";
export default {
  name: 'TypeIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-type"
    }, { ...attrs
    }), [createVNode("polyline", {
      "points": "4 7 4 4 20 4 20 7"
    }), createVNode("line", {
      "x1": "9",
      "y1": "20",
      "x2": "15",
      "y2": "20"
    }), createVNode("line", {
      "x1": "12",
      "y1": "4",
      "x2": "12",
      "y2": "20"
    })]);
  }

};