import { createVNode, mergeProps } from "vue";
export default {
  name: 'WifiIcon',
  props: {
    size: {
      type: String,
      default: '16',
      validator: s => !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x'
    }
  },

  setup(props, ctx) {
    const size = props.size.slice(-1) === 'x' ? props.size.slice(0, props.size.length - 1) + 'em' : parseInt(props.size) + 'px';
    const attrs = { ...ctx.attrs
    };
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    return () => createVNode("svg", mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "fill": "none",
      "stroke": "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "class": "feather feather-wifi"
    }, { ...attrs
    }), [createVNode("path", {
      "d": "M5 12.55a11 11 0 0 1 14.08 0"
    }), createVNode("path", {
      "d": "M1.42 9a16 16 0 0 1 21.16 0"
    }), createVNode("path", {
      "d": "M8.53 16.11a6 6 0 0 1 6.95 0"
    }), createVNode("line", {
      "x1": "12",
      "y1": "20",
      "x2": "12.01",
      "y2": "20"
    })]);
  }

};