import type { AriaInvalid, Booleanish, Size } from '../types';
export interface CommonInputProps {
    ariaInvalid?: AriaInvalid;
    autocomplete?: string;
    autofocus?: Booleanish;
    disabled?: Booleanish;
    form?: string;
    debounce?: string | number;
    debounceMaxWait?: string | number;
    formatter?: (val: string, evt: Event) => string;
    id?: string;
    lazy?: Booleanish;
    lazyFormatter?: Booleanish;
    list?: string;
    modelValue?: string | number;
    name?: string;
    number?: Booleanish;
    placeholder?: string;
    plaintext?: Booleanish;
    readonly?: Booleanish;
    required?: Booleanish;
    size?: Size;
    state?: Booleanish | null | undefined;
    trim?: Booleanish;
}
declare const _default: (props: Readonly<CommonInputProps>, emit: ((evt: 'update:modelValue', val: any) => void) & ((evt: 'change', val: any) => void) & ((evt: 'blur', val: any) => void) & ((evt: 'input', val: any) => void)) => {
    input: import("vue").Ref<HTMLInputElement | null>;
    computedId: import("vue").ComputedRef<string>;
    computedAriaInvalid: import("vue").ComputedRef<"true" | "false" | "grammar" | "spelling" | undefined>;
    onInput: (evt: Event) => void;
    onChange: (evt: Event) => void;
    onBlur: (evt: FocusEvent) => void;
    focus: () => void;
    blur: () => void;
};
export default _default;
